# File : "mfUtilities.tcl"
#                        Created : 2001-02-06 22:07:36
#              Last modification : 2001-02-14 11:29:41
# Author : Bernard Desgraupes
# e-mail : <berdesg@easynet.fr>
# www : <http://perso.easynet.fr/~berdesg/>
# Description : this file is part of the Metafont Mode package for 
# Alpha. See comments at the beginning of 'mfMode.tcl'.

namespace eval Mf {}


# Utility procs
# =============

proc Mf::setnames {name} {
    global mf_params MfmodeVars
    set mf_params(fullfilename) $name
    set mf_params(dirfilename) [file dirname $name]
    set mf_params(tailfilename) [file tail $name]
    set mf_params(basefilename) [file rootname [file tail $name]]
    set mf_params(extfilename) [file extension [file tail $name]]
    if {$MfmodeVars(useWorkFold) == 0} {
	set mf_params(outputfolder) $mf_params(dirfilename)
    } else {
	set mf_params(outputfolder) $MfmodeVars(MfworkFolder)
    }
}

proc Mf::getMfVersion {} {
    global  MfmodeVars 
    if {$MfmodeVars(mfAppSig) != "CMT3"} {return}
    set sig "CMT3"
    set vers [objectProperty 'MACS' vers "obj {want:type(file), seld:$sig, form:fcrt, from:'null'()}"]
    if {[regexp {\.* (.*).*\\}$} $vers longvers numvers]} {
	return [list [string trim $longvers "\r\}"] [string trim $numvers "\r\}"]]
    } else {
	beep 
	message "Can't get version info"
	return
    }
}

# This proc looks in the current log file for a line indicating the name of
# the output file produced by Metafont so that we do not have to  calculate
# the extension (which depends on the printer mode and the magnification)
proc Mf::findgfFile {} {
    global mf_params MfmodeVars
    switch $MfmodeVars(mfAppSig) {
	"CMT3" { 	
	    if {$mf_params(mfset)} {
		set mf_params(mfwd) $mf_params(folderpath)
	    } else {set mf_params(mfwd) $mf_params(outputfolder)}
	    if {![file exists [file join $mf_params(mfwd) $mf_params(basefilename).log]]} {
		beep 
		alertnote "Can't find file $mf_params(basefilename).log ; did you process $mf_params(basefilename).mf ?"
		return
	    }
	    catch {open [file join $mf_params(mfwd) $mf_params(basefilename).log]} fileId
	}
	"OzMF" {
	    if {$mf_params(mfset)} {
		set mf_params(mfwd) $mf_params(folderpath)
	    } else {set mf_params(mfwd) [file dirname [win::Current]]}
	    if {![file exists [file join $mf_params(mfwd) $mf_params(basefilename).log]]} {
		beep 
		alertnote "Can't find file $mf_params(basefilename).log ; \
		  did you process $mf_params(basefilename).mf ? Check that the \"delete_log\" \
		  flag in OzMetafont configs is set to false."
		return
	    }
	    catch {open [file join $mf_params(mfwd) $mf_params(basefilename).log]} fileId
	}
    }
    catch {read $fileId} textlog
    if {[regexp "\.(\\d+gf)" $textlog dum ext]} {
	set mf_params(gffile) "$mf_params(basefilename).$ext"
    } else {
	alertnote "According to $mf_params(basefilename).log, no gf output written."
	return ""
    }
} 
    
proc Mf::findmoderes {} {
	global MfmodeVars mf_params
	if {$mf_params(chosenMode) == "proof"} {
	return [list "proof" "2602"]
	}
	if {$mf_params(chosenMode) == "smoke"} {
	return [list "smoke" "2602"]
	}
	if {[file exists $MfmodeVars(pathToModesMfFile) ]} {
		message "reading $MfmodeVars(pathToModesMfFile)"
		catch {open "$MfmodeVars(pathToModesMfFile)"} fileId
		catch {read $fileId} textlog
		# First we find the value of localfont
		if {$mf_params(chosenMode) == "localfont"} {
			regexp {localfont([^\;]*)\;} $textlog blabla localMfmode
			set localMfmode [string trim $localMfmode " :="]
		} elseif {$mf_params(chosenMode) == "smoke"} {
			set localMfmode $mf_params(chosenMode)
		} else {
			set localMfmode $MfmodeVars(mfModeForPrinter)			
		}
		# Then we find the resolution in dpi
		set start [string first "mode_def $localMfmode" $textlog]
		if {$start == -1} {
			alertnote "Unknown mode $localMfmode."
			return
		}
		set textlog [string range $textlog $start end]
		regexp {pixels_per_inch[^0-9)]*([0-9]*)} $textlog blabla resdpi
		return [list $localMfmode $resdpi]
	} else {
		alertnote "Can't find file modes.mf : set the path in the Current Mode Prefs."
		return [list "proof" "2602"]
	}
}

proc Mf::checkMfoutputFolder {} {
    global MfmodeVars mf_params
    if {$mf_params(outputfolder) == "" } {
	catch {get_directory -p "Select the output folder"} rootpath
	set mf_params(outputfolder) [set rootpath]
	set MfmodeVars(MfworkFolder) $rootpath
	prefs::modified MfmodeVars(MfworkFolder)
    }
}

proc Mf::openMacroFile {flag name} {
	global MfmodeVars $flag
	if {[file exists $MfmodeVars($flag) ]} {
		message "opening $MfmodeVars($flag)"
		edit -r $MfmodeVars($flag) 
	} else {
		alertnote "Can't find file $name : where is it ?"
		catch {getfile "Please locate $name"}  chemin
	if {$chemin==""} {return}
		set $flag $chemin
		set MfmodeVars($flag) [set chemin]
		prefs::modified MfmodeVars($flag)
		edit -r $MfmodeVars($flag)
	}
}

proc Mf::openmodesmfProc {} {Mf::openMacroFile "pathToModesMfFile" "modes.mf"}

proc Mf::openplainmfProc {} {Mf::openMacroFile "pathToPlainMfFile" "plain.mf"}
 
proc Mf::deleteallfilesProc {ext} { 
    global MfmodeVars mf_params
    if {$mf_params(currentdir) == ""} {
	switch $MfmodeVars(mfAppSig) {
	    "CMT3" {
		set mf_params(currentdir) $mf_params(outputfolder)
	    }
	    "OzMF" {
		set mf_params(currentdir) [file dirname [win::Current]]
	    }
	}
    }
    if {![regexp "gf" $ext] && ![regexp "pk" $ext]} {
	set ext ".$ext"
    }
    set mf_params(filesindir) [glob -nocomplain -dir [file join $mf_params(currentdir)] *$ext]
    set long [llength $mf_params(filesindir)]
    if {$long == 0} {
	alertnote "No \"$ext\" file in output folder."
	return
    }
    switch [buttonAlert "OK to remove all \"$ext\" files from $mf_params(currentdir) ?" "yes" "cancel" ] {
	"yes" {
	    foreach file $mf_params(filesindir) {
		catch {file delete $file}
	    }
	}
	"cancel" {return}
    }
}


# --------------------------------------------------------------------------
# In this proc, choose the number of horizontal and vertical lines in a grid
# --------------------------------------------------------------------------
proc Mf::mkgridProc {} {
    set macroName "makegrid"
    beep
    catch {prompt "$macroName:  how many x-coordinates ?" 3} numbx
    if {$numbx == "cancel"} {
	return
    } elseif {![is::PositiveInteger $numbx]} {
	beep
	message "invalid input: please enter a positive integer"
	return
    }
    catch {prompt "$macroName:  how many y-coordinates ?" 3} numby
    if {$numby == "cancel"} {
	return
    } elseif {![is::PositiveInteger $numby]} {
	beep
	message "invalid input: please enter a positive integer"
	return
    }
    if {$numbx && $numby} {
	set body "makegrid("
	for {set i 1} {$i < $numbx} {incr i} {
	    append body ","
	}
	append body ")("
	for {set i 1} {$i < $numby} {incr i} {
	    append body ","
	}
	append body ");\n"
    } else {
	set body "\r"
    }
    insertObject $body
}

# --------------------------------------------------------------------------
# In this proc, choose the number of points on a flex path
# --------------------------------------------------------------------------
proc Mf::mkflexProc {} {
    set macroName "flex"
    beep
    catch {prompt "$macroName:  how many points on the flex-path ?" 3} numbp
    if {$numbp == "cancel"} {
	return
    } elseif {![is::PositiveInteger $numbp]} {
	beep
	message "invalid input: please enter a positive integer"
	return
    }
    if {$numbp} {
	set body "flex("
	for {set i 1} {$i < $numbp} {incr i} {
	    append body ","
	}
	append body ") "
    } else {
	set body "\r"
    }
    insertObject $body
}

# --------------------------------------------------------------------------
# In this proc, choose the number of points on a penstroke
# --------------------------------------------------------------------------
proc Mf::penstrokeProc {} {
    set macroName "penstroke"
    beep
    catch {prompt "$macroName:  how many points on the penstroke ?" 3} numbp
    if {$numbp == "cancel"} {
	return
    } elseif {![is::PositiveInteger $numbp]} {
	beep
	message "invalid input: please enter a positive integer"
	return
    }
    if {$numbp} {
	set body "penstroke z1e"
	for {set i 2} {$i < [expr {$numbp + 1}]} {incr i} {
	    append body "..z${i}e"
	}
	append body " ;"
    } else {
	set body "\r"
    }
    insertObject $body
}

